本题考察 **哈希表** 的使用，本文介绍 **哈希表** 和 **有序哈希表** 两种解法。其中，在字符串长度较大、重复字符很多时，“有序哈希表” 解法理论上效率更高。

## 方法一：哈希表

1. 遍历字符串 `s` ，使用哈希表统计 “各字符数量是否 $> 1$ ”。
2. 再遍历字符串 `s` ，在哈希表中找到首个 “数量为 $1$ 的字符”，并返回。

![Picture1.png](https://pic.leetcode-cn.com/ed093aabc9195caff6d088454eaebe3cad875e8ca4a643c004ef25e4e5e9e174-Picture1.png){:width=450}

### 算法流程：

1. **初始化：** 字典 (Python)、HashMap(Java)、map(C++)，记为 `dic` ；
2. **字符统计：** 遍历字符串 `s` 中的每个字符 `c` ；
   1. 若 `dic` 中 **不包含** 键(key) `c` ：则向 `dic` 中添加键值对 `(c, True)` ，代表字符 `c` 的数量为 $1$ ；
   2. 若 `dic` 中 **包含** 键(key) `c` ：则修改键 `c` 的键值对为 `(c, False)` ，代表字符 `c` 的数量 $> 1$ 。 
3. **查找数量为 $1$ 的字符：** 遍历字符串 `s` 中的每个字符 `c` ；
   1. 若 `dic`中键 `c` 对应的值为 `True` ：，则返回 `c` 。
4. 返回 `' '` ，代表字符串无数量为 $1$ 的字符。

<![Picture2.png](https://pic.leetcode-cn.com/776cae7063c810e0f86031d44099b199c5f55f81f4d58ffbad19f1d798d31550-Picture2.png),![Picture3.png](https://pic.leetcode-cn.com/5b6324b396d06abe0511f81fa67a1eb795bad6a37e94e9ef6bde8557967ab8bc-Picture3.png),![Picture4.png](https://pic.leetcode-cn.com/240c928b3110664fbdd9c86aa44e4a6a34e29ceb55531b2640a802a00bf4a46f-Picture4.png),![Picture5.png](https://pic.leetcode-cn.com/7cb3b93272e8e7f770a32ce0c39271dc4b50804cc6e4dbe9541d2b9d64e96db8-Picture5.png),![Picture6.png](https://pic.leetcode-cn.com/5c68b55d5a5abae9223db9f380bcd199b5da5c8f9248e4809298b685f218d29a-Picture6.png),![Picture7.png](https://pic.leetcode-cn.com/aea83f7d093a5662867d34a8fc8da26ada4bbe7b64868d697645848167f6f3eb-Picture7.png),![Picture8.png](https://pic.leetcode-cn.com/32cf6ba91b799bf1f625fa39796f73a60dfad041589e82d0ed3545d08393f3bb-Picture8.png),![Picture9.png](https://pic.leetcode-cn.com/10bc69cab88ba6f5071b8b67c370d1e1dfa0db2e341268191c41e1e9c9820d52-Picture9.png),![Picture10.png](https://pic.leetcode-cn.com/4b44c787abeed308cbfc5c92cb72922d63cd7806b4524c961e025aac8bf59fbf-Picture10.png),![Picture11.png](https://pic.leetcode-cn.com/f0e078920fee1d2486d489fbaa10c75a3da3c2f3703d810509cfc8581b118274-Picture11.png),![Picture12.png](https://pic.leetcode-cn.com/98825f51afdf7c59df3bbb9a9370406d82cd1425eb5eaa508335cd727a82983d-Picture12.png)>

### 复杂度分析：

- **时间复杂度 $O(N)$ ：** $N$ 为字符串 `s` 的长度；需遍历 `s` 两轮，使用 $O(N)$ ；HashMap 查找操作的复杂度为 $O(1)$ ；
- **空间复杂度 $O(1)$ ：** 由于题目指出 `s`  只包含小写字母，因此最多有 26 个不同字符，HashMap 存储需占用 $O(26) = O(1)$ 的额外空间。

### 代码：

Python 代码中的 `not c in dic` 整体为一个布尔值； `c in dic` 为判断字典中是否含有键 `c` 。

```Python []
class Solution:
    def firstUniqChar(self, s: str) -> str:
        dic = {}
        for c in s:
            dic[c] = not c in dic
        for c in s:
            if dic[c]: return c
        return ' '
```

```Java []
class Solution {
    public char firstUniqChar(String s) {
        HashMap<Character, Boolean> dic = new HashMap<>();
        char[] sc = s.toCharArray();
        for(char c : sc)
            dic.put(c, !dic.containsKey(c));
        for(char c : sc)
            if(dic.get(c)) return c;
        return ' ';
    }
}
```

```C++ []
class Solution {
public:
    char firstUniqChar(string s) {
        unordered_map<char, bool> dic;
        for(char c : s)
            dic[c] = dic.find(c) == dic.end();
        for(char c : s)
            if(dic[c]) return c;
        return ' ';
    }
};
```

## 方法二：有序哈希表

在哈希表的基础上，有序哈希表中的键值对是 **按照插入顺序排序** 的。基于此，可通过遍历有序哈希表，实现搜索首个 “数量为 $1$ 的字符”。

哈希表是 **去重** 的，即哈希表中键值对数量 $\leq$ 字符串 `s` 的长度。因此，相比于方法一，方法二减少了第二轮遍历的循环次数。当字符串很长（重复字符很多）时，方法二则效率更高。

### 复杂度分析：

时间和空间复杂度均与 “方法一” 相同，而具体分析：方法一 需遍历 `s` 两轮；方法二 遍历 `s` 一轮，遍历 `dic` 一轮（ `dic` 的长度不大于 26 ）。

### 代码：

Python 3.6 后，默认字典就是有序的，因此无需使用 `OrderedDict()` ，详情可见：[为什么Python 3.6以后字典有序并且效率更高？](https://www.cnblogs.com/xieqiankun/p/python_dict.html)

Java 使用 `LinkedHashMap` 实现有序哈希表。

由于 C++ 未提供自带的链式哈希表，因此借助一个 vector 按序存储哈希表 dic 中的 key ，第二轮遍历此 vector 即可。

```Python []
class Solution:
    def firstUniqChar(self, s: str) -> str:
        dic = collections.OrderedDict()
        for c in s:
            dic[c] = not c in dic
        for k, v in dic.items():
            if v: return k
        return ' '
```

```Python []
class Solution:
    def firstUniqChar(self, s: str) -> str:
        dic = {}
        for c in s:
            dic[c] = not c in dic
        for k, v in dic.items():
            if v: return k
        return ' '
```

```Java []
class Solution {
    public char firstUniqChar(String s) {
        Map<Character, Boolean> dic = new LinkedHashMap<>();
        char[] sc = s.toCharArray();
        for(char c : sc)
            dic.put(c, !dic.containsKey(c));
        for(Map.Entry<Character, Boolean> d : dic.entrySet()){
           if(d.getValue()) return d.getKey();
        }
        return ' ';
    }
}
```

```C++ []
class Solution {
public:
    char firstUniqChar(string s) {
        vector<char> keys;
        unordered_map<char, bool> dic;
        for(char c : s) {
            if(dic.find(c) == dic.end())
                keys.push_back(c);
            dic[c] = dic.find(c) == dic.end();
        }
        for(char c : keys) {
            if(dic[c]) return c;
        }
        return ' ';
    }
};
```

\
{:style="text-align: center;"}

欢迎您对「图解算法数据结构」提出评论、意见或期待
{:style="text-align: center;"}